%This program runs the simulations behind Fig. OA.8.

%In this accommodation case player 1 is an AM and player 2 is a human with a
%dynamic manipulation strategy, aimed at "teaching" player 1 to play above
%the monopoly price.

%The program conducts 1000 experiments of 1.10^6 episodes, with Delta_v = 4
%and \sigma = 5, and records the average outcome in each episode as well as
%all the variables in the last episode.

clear

% record running time
% when producing the data the running time was 13 minutes
tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.      
N = 2;                  %N is the number of AMMs.

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l=5;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

%The grid is different from the baseline case used in the paper: prices are
%between 2 and 8 with a tick size of 1.

grid_middle = 5;
grid_size= 3;  
tick= 1;      

%Pre program the human's strategy, for the moment it is minimizing player 1's payoff:
% (will be modified in simulation_exp_accommodation):

%If player 1 plays 2 then play 3, as this gives player 1 a negative profit
%on average. Otherwise undercut by one tick.
BR = zeros(2*grid_size+1,1);
for i=1:7
BR(i,1) = (grid_middle - grid_size*tick - tick)+(i*tick)-tick;
end
BR(1,1) = 3;
 
% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

%Call the function simulation_rep_exclusion to run K experiments
[last_episodes, av_all_episodes]=simulation_rep_accommodation(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K,BR);

toc

%Save the output in the subfolder "Data"
writematrix(last_episodes,'Data/last_episodes_accommodation.txt');
writematrix(av_all_episodes,'Data/av_all_episodes_accommodation.txt');

